<?php
class UsersAdmin
{
  private $dbo = null;
  function __construct($dbo)
  {
    $this->dbo = $dbo;
  }
  
  function getQuerySingleResult($query)
  {
    //Brak obiektu $dbo
    if(!$this->dbo) return false;
    
    //Wykonanie zapytania.
    if(!$result = $this->dbo->query($query)){
      //echo 'Wyst?pi? b??d (getQuerySingleResult): nieprawid?owe zapytanie...';
      return false;
    }
    if($row = $result->fetch_row()){
      //Zwr?cenie wyniku.
      return $row[0];
    }
    else{
      //Brak wynik?w zapytania.
      return false;
    }
  }
  
  function getPagination($page, $pages, $link, $msg)
  {
    $str = '';
    for($i = 0; $i < $pages; $i++){
      if($i != $page){
        $str .= "<a href=\"$link&amp;page=$i\">".($i+1)."</a>";
      }
      else{
        $str .= '<span class="activePaginationPage">' . ($i+1)
              . '</span>';
      }
      $str .= '<span class="space"> </span>';
    }
    $str = $msg . $str;
    return $str;
  }
  
  function showList($limit)
  {
    if(!$this->dbo){
      echo 'Lista u?ytkownik?w nie jest dost?pna.';
      return;
    }
    
    //Odczytanie parametru page
    if(isset($_GET['page'])){
      $page = intval($_GET['page']);
    }
    else{
      $page = 0;
    }
    
    //Okre?lenie ca?kowitej liczby wierszy w tabeli Users
    $query = "SELECT COUNT(*) FROM Users";
    $rowsCount = (int) $this->getQuerySingleResult($query);
    
    //Obliczenie ca?kowitej liczby stron z wynikami
    $pages = ceil($rowsCount / $limit);
    
    if($page < 0 || $page >= $pages) $page = 0;
    
    $offset = $page * $limit;
    
    //Zapytanie pobieraj?ce wyniki dla bie??cej strony
    $query = "SELECT Id, Nazwa, Imie, Nazwisko, Email "
           . "FROM Users LIMIT $offset, $limit";

    if(!$users = $this->dbo->query($query)){
      return;
    }
    include 'templates/usersList.php';
  }
  
  function showEditForm($action)
  {
    if(!$this->dbo) return SERVER_ERROR;
    
    //Edycja istniej?cego konta.
    if($action == 'edit'){
      //Sprawdzenie czy istnieje parametr id.
      if(!isset($_GET['id'])){
        echo 'Brak parametru id.';
        return FORM_DATA_MISSING;
      }
      
      //Sprawdzenie poprawno?ci parametru id.
      if(($id = (int)($_GET['id'])) < 1){
        echo 'Nieprawid?owy parametr id.';
        return INVALID_USER_ID;
      }
      
      //Zapytanie pobieraj?ce dane.
      $query = "SELECT * FROM Users WHERE id=$id";
      
      if(!$result = $this->dbo->query($query)){
        echo 'B??d serwera. Niew?a?ciwe zapytanie MySQL.';
        return SERVER_ERROR;
      }
      if(!$row = $result->fetch_row()){
        echo 'Nieprawid?owy parametr id.';
        return INVALID_USER_ID;
      }
      
      //Ustawienie warto?ci zmiennych u?ywanych w formularzu.
      $id = $row[0];
      $nazwa = $row[1];
      $imie = $row[3];
      $nazwisko = $row[4];
      $email = $row[5];
      
      $wtd = 'modifyUser';
      $readonly = 'readonly';
      $disabled = 'disabled';
    }
    //Dodawanie nowego konta.
    else{
      $id = '';
      $nazwa = '';
      $imie = '';
      $nazwisko = '';
      $email = '';
      $wtd = 'addUser';
      $readonly = '';
      $disabled = '';
    }
    include 'templates/editUserForm.php';
  }
}
?>